﻿#define _CRT_SECURE_NO_WARNINGS

#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <queue>
#include <deque>
#include <set>
#include <map>
#include <iomanip>
#include <cmath>

typedef long long ll;
typedef long double ld;

using namespace std;

const int N = 4e3 + 2;
const int INT_INF = 1e9;
const ll LONG_INF = 1e18;

struct Dfs {
    vector<int> a[N];
    bool used[N];

    void dfs(int v) {
        used[v] = true;
        for (auto t : a[v]) {
            if (!used[t]) {
                dfs(t);
            }
        }
    }

};

struct Bfs {
    vector<int> a[N];
    bool used[N];

    void bfs(int v) {
        queue<int> q;
        q.push(v);

        while (!q.empty())
        {
            int t = q.front();
            used[t] = true;
            q.pop();

            for (auto to : a[t]) {
                if (!used[to]) {
                    q.push(to);
                }
            }
        }
    }
};

struct Djikstra {
    vector<pair<ll, int>> a[N];

    vector<ll> djikstra(int v) {
        vector<ll> ans(N);
        ans[v] = LONG_INF;

        set<pair<ll, int>> s;
        s.insert({ 0, v });

        while (!s.empty())
        {
            int t = s.begin()->second;
            s.erase(s.begin());

            for (auto to : a[t]) {
                if (ans[to.second] > ans[t] + to.first) {
                    s.erase({ ans[to.second], to.second });
                    ans[to.second] = ans[t] + to.first;
                    s.insert({ ans[to.second], to.second });
                }
            }
        }

        return ans;
    }
};

struct SegTree {
    ll tree[N];
    ll a[N];

    void update(int v, int l, int r, int x, int id) {
        if (l == r - 1) {
            tree[v] = x;
            return;
        }
        
        int m = (l + r) / 2;
        if (m > id) {
            update(2 * v + 1, l, m, x, id);
        }
        else {
            update(2 * v + 2, m, r, x, id);
        }

        tree[v] = tree[2 * v + 1] + tree[2 * v + 2];
    }

    ll get(int v, int l, int r, int ql, int qr) {
        if (l >= qr || r <= ql) {
            return 0;
        }
        if (l >= ql && r <= qr) {
            return tree[v];
        }

        int m = (l + r) / 2;
        return get(2 * v + 1, l, m, ql, qr) + get(2 * v + 2, m, r, ql, qr);
    }
};

ll gcd(ll a, ll b) {
    return (b == 0) ? a : gcd(b, a % b);
}

vector<int> par(N, -1), rk(N, 0);

int get_par(int v) {
    if (par[v] == -1) {
        return v;
    }
    return par[v] = get_par(par[v]);
}

void unite(int v, int q) {
    int pv = get_par(v), pq = get_par(q);
    if (pv == pq) {
        return;
    }

    if (rk[pq] > rk[pv]) {
        swap(pv, pq);
    }
    par[pq] = pv;

    if (rk[pv] == rk[pq]) {
        rk[pv]++;
    }
}

struct line {
    int x1, y1, x2, y2;
};
struct vec {
    int x, y;
};

ld vec_m(vec a, vec b) {
    return a.x * b.y - a.y * b.x;
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    //freopen("in.txt", "r", stdin);
    //freopen("in.txt", "w", stdout);

    int t; cin >> t;
    while (t--)
    {
        fill(par.begin(), par.end(), -1);
        fill(rk.begin(), rk.end(), 0);
        int n; cin >> n;
        ll ans = 1;
        vector<pair<int, line>> a;
        for (int i = 0; i < n; i++) {
            line l; cin >> l.x1 >> l.y1 >> l.x2 >> l.y2;

            map<int, int> used;
            for (auto C : a) {

                line c = C.second;
                vec v1 = { l.x2 - l.x1, l.y2 - l.y1 };
                vec v2 = { c.x1 - l.x1, c.y1 - l.y1 };
                vec v3 = { c.x2 - l.x1, c.y2 - l.y1 };

                vec v4 = { c.x2 - c.x1, c.y2 - c.y1 };
                vec v5 = { l.x1 - c.x1, l.y1 - c.y1 };
                vec v6 = { l.x2 - c.x1, l.y2 - c.y1 };

                if (vec_m(v1, v2) * vec_m(v1, v3) <= 0 && vec_m(v4, v5) * vec_m(v4, v6) <= 0) {
                    used[get_par(C.first)]++;
                    unite(C.first, i);
                }
            }

            a.push_back({ i, l });
            for (auto c : used) {
                ans += c.second - 1;
            }
            used.clear();
        }

        cout << ans << '\n';
    }


    return 0;
}
